<?php namespace My\Field\wheeditor; // demo是插件目录

class Wheeditor extends \Phpcmf\Library\A_Field {

    /**
     * 构造函数
     */
    public function __construct(...$params) {
        parent::__construct(...$params);
        $this->fieldtype = TRUE;
        $this->defaulttype = 'TEXT'; // 默认显示的类型
    }

    /**
     * 字段相关属性参数
     */
    public function option($option) {
        return [
            $this->field_type($option['fieldtype'], $option['fieldlength']),
            ''
        ];
    }


    /**
     * 字段显示
     */
    public function show($field, $value = null) {
        $html = '
        <div class="portlet  bordered light">
        <div class="portlet-body">
        <div class="gctscroller" style="width:100%" data-always-visible="1" data-rail-visible="1">
        '.nl2br(htmlentities($value)).'                
        </div>
        </div>
        </div>';
        return $this->input_format($field['fieldname'], $field['name'], $html);
    }

    /**
     * 字段表单输入
     */
    public function input($field, $value = '') {

        // 字段禁止修改时就返回显示字符串
        if ($this->_not_edit($field, $value)) {
            return $this->show($field, $value);
        }

        // 字段存储名称
        $name = $field['fieldname'];

        // 字段显示名称
        $text = ($field['setting']['validate']['required'] ? '<span class="required" aria-required="true"> * </span>' : '').dr_lang($field['name']);


        // 表单附加参数
        $attr = $field['setting']['validate']['formattr'];

        // 字段提示信息
        $tips = $field['setting']['validate']['tips'] ? '<span class="help-block" id="dr_'.$field['fieldname'].'_tips">'.$field['setting']['validate']['tips'].'</span>' : '';

        // 表单高度设置
        $height = $field['setting']['option']['height'] ? $field['setting']['option']['height'] : '500';

        // 字段默认值
        $value = strlen($value) ? $value : $this->get_default_value($field['setting']['option']['value']);

        $info = \Phpcmf\Service::M('wheeditor', 'wheeditor')->get_info();
        $cdn = \Phpcmf\Service::M('wheeditor', 'wheeditor')->get_cdn($info['cdn']['value']);
        $toolbar = \Phpcmf\Service::M('wheeditor', 'wheeditor')->get_toolbar();
        $mode = $info['mode']['value'] ?? 'ir';

        // 是否展示大纲
        if($info['outline']['value'] == false){
          $is_outline = false;
        }else{
          $is_outline = true;
        }

        // 是否展示字数
        if($info['counter']['value'] == 'false'){
          $is_counter = 'false';
        }else{
          $is_counter = 'true';
        }

        $str = '
  <link rel="stylesheet" href="'.  $cdn['url'] .'/dist/index.css" />
  <textarea id="content" name="data['.$name.']" style="display:none;"></textarea>
  <div id="wheeditor_'.$name.'"></div>

<div id="output"></div>

<script src="'. $cdn['url'] .'/dist/index.min.js"></script>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const defaultValue = '. json_encode($value, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP).';

    const wheeditor_'.$name.' = new Vditor("wheeditor_'.$name.'", {
      cdn: "'. $cdn['url'] .'",
      height: 400,
      "resize": {
        "enable": true,
        "position": "bottom"
      },
      icon: "'.$info['icon']['value'].'",
      lang: "'.$info['lang']['value'].'",
      placeholder: "请输入...",
      mode: "'.$mode.'",
      // 编辑器内容变化时，同步到 textarea
      input: (value) => {
        document.getElementById("content").value = value;
      },
      toolbar: ['.$toolbar.'],

      "outline": {
        "enable": '.$is_outline.',
        "position": "'.$info['outline']['value'].'"
      },

      "counter": {
        "enable": '.$is_counter.',
        "type": "'.$info['counter']['value'].'"
      },

      // 初始化完成后设置默认值并同步
      after: () => {
        wheeditor_'.$name.'.setValue(defaultValue);
        document.getElementById("content").value = defaultValue; // 同步到 textarea
      },
      "fullscreen": {
        "index": 7777
      },

      "preview": {
        "hljs": {
          "lineNumber": '.$info['codeBlock_lineNumber']['value'].',
          "enable": "'.$info['codeBlock_theme']['value'].'",

        },
        "markdown": {
          "codeBlockPreview": '.$info['codeBlock_preview']['value'].',
        }
      },

    });

  });
</script>
';



        return $this->input_format($name, $text, $str.$tips);
    }

}